# Rule 5.5 Identifiers shall be distinct from macro names

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Applies to
C90, C99, C11

## Amplification
This rule requires that the names of macros that exist prior to preprocessing be distinct from the identifiers that exist after preprocessing. It applies to identifiers, regardless of scope or name space, and to any macros that have been defined regardless of whether the definition is still in force when the identifier is declared.

The definition of distinct depends on the implementation and the edition of the C Standard that is being used:
*   In C90 the **minimum** requirement is that the first 31 characters are significant;
*   In C99 and later the **minimum** requirement is that the first 63 characters are significant, with each universal character or extended source character counting as a single character.

## Rationale
Keeping macro names and identifiers distinct can help to avoid developer confusion.

## Example
In the following non-compliant example, the name of the *function-like macro* `Sum` is also used as an identifier. The declaration of the object `Sum` is not subject to macro-expansion because it is not followed by a `(` character. The identifier therefore exists after preprocessing has been performed.

```c
#define Sum(x, y) ( ( x ) + ( y ) )

int16_t Sum;
```

The following example is compliant because there is no instance of the identifier `Sum` after preprocessing.

```c
#define Sum(x, y) ( ( x ) + ( y ) )

int16_t x = Sum ( 1, 2 );
```

In the following example, the implementation in question supports 31 significant case-sensitive characters in identifiers that do not have external linkage. The example is non-compliant because the macro name is not distinct from an identifier name with internal linkage in the first 31 characters.

```c
/*      1234567890123456789012345678901********* Characters */
#define low_pressure_turbine_temperature_1 lp_tb_temp_1
static int32_t low_pressure_turbine_temperature_2;
```

## See also
Rule 5.1, Rule 5.2, Rule 5.4

---

Copyright The MISRA Consortium Limited © [Date - March 2025].