# Rule 14–7–1 (Required) All class templates, function templates, class template member functions and class template static members shall be instantiated at least once.

## Rationale
Similar to uncalled functions, un-instantiated class and function templates are a potential source of noise and they may be symptomatic of a more serious problem such as missing paths.
Note: Even though a given class template may be instantiated many times, it is possible that some of its member functions are never instantiated.
See Section 3.5 for associated library issues.

## Example
```c
template < typename T > 
class Sample 
{ 
public: 
 void inst_mem ( ) 
 { 
 ... 
 }
 void uninst_mem ( ) // Non-compliant 
 { 
 ... 
 }
};
Sample<int64_t> s; 
s.inst_mem ( ); // Call to s.inst_mem instantiates the member. 
 // s.uninst_mem is not called within the program 
 // and is not instantiated.
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
