# Rule 14–7–2 (Required) For any given template specialization, an explicit instantiation of the template with the template-arguments used in the specialization shall not render the program ill-formed.

## Rationale
An implicit template specialization does not instantiate every member of the template. Where instantiation of a member would result in an ill-formed program it is not clear that the template should be used with the supplied template-arguments.
See Section 3.5 for associated library issues.

## Example
```c
template <typename T> 
class A 
{ 
public: 
 void f1 () 
 { 
 // ... 
 }
 void f2 () 
 { 
 T t;
 t.x = 0; // Will only work for types that have a .x member 
 } 
};
void b () 
{ 
 A<int32_t> a; // A<int32_t>::f2 is not instantiated.
 a.f1 (); 
}
template class A<int32_t>; // Non-compliant - instantiation of f2 
 // results in "ill-formed" program.
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
