# Rule 15–3–2 (Advisory) There should be at least one exception handler to catch all otherwise unhandled exceptions

## Amplification
[Implementation 15.3(9), 15.5.1(2)]

## Rationale
If a program throws an unhandled exception it terminates in an implementation-defined manner. In particular, it is implementation-defined whether the call stack is unwound, before termination, so the destructors of any automatic objects may or may not be executed. By enforcing the provision of a “last-ditch catch-all”, the developer can ensure that the program terminates in a consistent manner.
The objective of Rule 15–3–4 is that a program should catch all exceptions that it is expected to throw. This rule’s objective is to ensure that exceptions that were not expected are also caught.

## Example
For the majority of programs this will mean main should look like:
```c
int32_t main( ) 
{ 
 try 
 { 
 // program code 
 }
 catch ( ... ) // Catch-all handler 
 { 
 // Handle unexpected exceptions 
 } 
 return 0; 
}
```

## See also
Rule 15–3–4, Rule 15–5–3

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
