# Rule 16–3–2 (Advisory) The # and ## operators should not be used.

## Category
Advisory

## Rationale
[Unspecified 16.3.2(2), 16.3.3(3), Undefined 16.3.2(2), 16.3.3(3)]

The order of evaluation associated with both the # and ## preprocessor operators is unspecified.
Compilers have been known to implement these operators inconsistently, therefore, to avoid these
problems, do not use them.

## Example
```cpp
#define A(Y) #Y // Non-compliant 
#define A(X,Y) X##Y // Non-compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
