# Rule 2–10–3 (Required) A typedef name (including qualification, if any) shall be a unique identifier.

## Rationale
Reusing a typedef name either as another typedef name or for any other purpose may lead to developer confusion.
The same typedef shall not be duplicated anywhere in the project, even if the declarations are identical.
Note that where the type definition is made in a header file, and that header file is included in multiple source files, this rule is not violated.

## Example
```c
// f1.cc 
namespace NS1 
{ 
 typedef int16_t WIDTH; 
}
// f2.cc 
namespace NS2 
{ 
 float32_t WIDTH; // Compliant - 
 // NS2::WIDTH is not the same as NS1::WIDTH 
}
void f1 ( ) 
{ 
 typedef int32_t TYPE; 
}
void f2 ( ) 
{ 
 float32_t TYPE; // Non-compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
