# Rule 2–13–3 (Required) A “U” suffix shall be applied to all octal or hexadecimal integer literals of unsigned type.

## Rationale
The type of an integer is dependent on a complex combination of factors including:
* The magnitude of the constant;
* The implemented sizes of the integer types;
* The presence of any suffixes;
* The number base in which the value is expressed (i.e. decimal, octal or hexadecimal).

For example, the value 0x8000 is of type unsigned int in a 16-bit environment, but of type (signed) int in a 32-bit environment. If an overload set includes candidates for an unsigned int and an int, then the overload that would be matched by 0x8000 is therefore dependent on the implemented integer size. Adding a “U” suffix to the value specifies that it is unsigned.
Note that the usage context may also require the use of suffixes, as shown in Section 6.5.0.

## Example
```c
template <typename T> 
void f ( T );
template <> 
void f < uint16_t > ( uint16_t );
template <> 
void f < int16_t > ( int16_t );
void b ( ) 
{ 
 uint16_t u16a = 0U; // Compliant
 f ( 0x8000 ); // Non-compliant on a 16-bit platform. 
 u16a = u16a + 0x8000; // Non-compliant as context is unsigned. 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
