# Rule 3–3–1 (Required) Objects or functions with external linkage shall be declared in a header file.

## Rationale
Placing the declarations of objects and functions with external linkage in a header file documents that they are intended to be accessible from other translation units.
If external linkage is not required, then the object or function shall either be declared in an unnamed namespace or declared static.
This will reduce the visibility of objects and functions, which is considered to be good practice.

## Exception
This rule does not apply to main, or to members of unnamed namespaces.

## Example
```c
// header.hpp 
extern int32_t a1; 
extern void f3 ( );
// file1.cpp 
#include "header.hpp"
 int32_t a1 = 0; // Compliant 
 int32_t a2 = 0; // Non-compliant 
static int32_t a3 = 0; // Compliant
namespace 
{ 
 int32_t a4 = 0; // Compliant
 void f1 () // Compliant 
 { 
 } 
}
static void f2 ( ) // Compliant 
{ 
}
void f3 ( ) // Compliant 
{ 
 a1 = 1; 
 a2 = 1; 
 a3 = 1; 
 a4 = 1; 
}
void f4 ( ) // Non-compliant 
{ 
 a1 = 2; 
 a2 = 2; 
 a3 = 2; 
 a4 = 2; 
}
void main ( ) // Compliant by exception 
{ 
 f1 ( ); 
 f2 ( ); 
 f3 ( ); 
 f4 ( ); 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
