# Rule 5–0–14 (Required) The first operand of a conditional-operator shall have type bool.

## Rationale
If an expression with type other than bool is used as the first operand of a conditional-operator, then its result will be implicitly converted to bool. The first operand shall contain an explicit test (yielding a result of type bool) in order to clarify the intentions of the developer.

## Example
```c
int32_a = int16_b ? int32_c : int32_d; // Non-compliant 
int32_a = bool_b ? int32_c : int32_d; // Compliant 
int32_a = ( int16_b < 5 ) ? int32_c : int32_d; // Compliant
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
