# Rule 5–2–10 (Advisory) The increment (++) and decrement (--) operators should not be mixed with other operators in an expression.

## Rationale
The use of increment and decrement operators in combination with other arithmetic operators is not recommended, because:
* It can significantly impair the readability of the code.
* It introduces additional side effects into a statement, with the potential for undefined behaviour.

It is safer to use these operators in isolation from any other arithmetic operators.

## Example
A statement such as the following is non-compliant:
```c
u8a = ++u8b + u8c--; // Non-compliant
```
The following sequence is clearer and therefore safer:
```c
++u8b; 
u8a = u8b + u8c; 
u8c--;
```

## See also
ISO/IEC 14882:2003 [1] §5.2.6, §5.3.2

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
