# Rule 7–5–1 (Required) A function shall not return a reference or a pointer to an automatic variable (including parameters), defined within the function.

## Rationale
Automatic variables are destroyed at the end of the function call. Returning a reference or pointer to such a variable allows it to be used after its destruction, leading to undefined behaviour.

## Example
```c
int32_t * fn1 ( void ) 
{ 
 int32_t x = 99;
 return ( &x ); // Non-compliant 
}
int32_t * fn2 ( int32_t y ) 
{ 
 return ( &y ); // Non-compliant 
}
int32_t & fn3 ( void ) 
{ 
 int32_t x = 99;
 return ( x ); // Non-compliant 
}
int32_t & fn4 ( int32_t y ) 
{ 
 return ( y ); // Non-compliant 
}
int32_t * fn5 ( void ) 
{ 
 static int32_t x = 0;
 return &x; // Compliant 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
