# Rule 8–4–2 (Required) The identifiers used for the parameters in a re-declaration of a function shall be identical to those in the declaration.

## Rationale
The name given to a parameter helps document the purpose of the parameter within the function body. If a function parameter is renamed in a subsequent re-declaration, then having different names for the same object will probably lead to developer confusion.
Note that the rule also applies to any overriding set.

## Exception
It is not a violation of this rule if the declaration or re-declaration contains an unnamed parameter.

## Example
```c
// File1 
void CreateRectangle ( uint32_t Height, uint32_t Width );
// File2 
// Non-compliant 
void CreateRectangle ( uint32_t Width, uint32_t Height );
void fn1 ( int32_t a ); 
void fn2 ( int32_t );
void fn1 ( int32_t b ) // Non-compliant 
{ 
}
void fn2 ( int32_t b ) // Compliant 
{ 
}
```

---

Copyright The MISRA Consortium Limited © [Date - June 2008].
