# Rule 11.3.1 Variables of array type should not be declared

## Category
Advisory

## Analysis
Decidable, Single Translation Unit

## Rationale
A variable of array type does not have value semantics and its size has to be managed separately. It is
possible to use types that do not have these limitations. For example:
*   `std::array` — provides value semantics and manages the size;
*   `std::string_view` — manages the size.

## Exception
The declaration of an array of `const` character type is permitted when it is immediately initialized with
a string literal.

## Example
```cpp
void foo() noexcept
{
 const size_t size { 10 };
 wchar_t a1 [ size ]; // Non-compliant
 std::array< wchar_t, size > a2; // Compliant
}

void bar( int a[ 10 ], // Rule does not apply - pointer to int
 int ( &b )[ 10 ], // Rule does not apply - reference to array
 int ( *c )[ 10 ]) // Rule does not apply - pointer to array
{
}

struct S
{
 std::uint16_t a3[ 10 ]; // Non-compliant
};

using namespace std::literals;

const char s1[] = "abcd"; // Compliant by exception
 char s2[] = "abcd"; // Non-compliant
const auto best = "abcd"sv; // Compliant
```

## See also
Rule 7.11.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
