# Rule 21.2.1 The library functions atof, atoi, atol and atoll from <cstdlib> shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Amplification
These functions shall not be called or have their addresses taken, and no macro having one of these
names shall be expanded.

*Note:* the same functions from `<stdlib.h>` are also covered by this rule.

## Rationale
These functions have *undefined behaviour* associated with them when the string cannot be converted.
The C++ library provides safer conversion routines — see [string.conversions], [charconv.from.chars].

*Note:* [charconv.from.chars] was changed from [utility.from.chars] as the result of a defect report
against the C++ Standard.

## Example
```cpp
int32_t f( const char * numstr )
{
 return atoi( numstr ); // Non-compliant
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
