# Rule 21.2.4 The macro offsetof shall not be used

## Category
Required

## Analysis
Decidable, Single Translation Unit

## Rationale
The `offsetof` macro is used to access the underlying representation of an object, breaking its
encapsulation. In addition, its use results in *undefined behaviour* when the specified member is a *bit-field*, a static data member, or a member function.

## Example
```cpp
struct A
{
 int32_t i;
};

void f1()
{
 offsetof( A, i ); // Non-compliant
}
```

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
