# Rule 9.6.4 A function declared with the [[noreturn]] attribute shall not return

## Category
Required

## Analysis
Undecidable, System

## Amplification
Leaving a function as the result of an exception is not a return.

A function's compliance with this rule is determined independently of the context in which the function
is called. For example, a Boolean parameter is treated as if it may have a value of `true` or `false`, even
if all the calls expressed in the current program use a value of `true`.

## Rationale
Returning from a function declared as `[[noreturn]]` results in *undefined behaviour*.

*Note:* a function may be declared as `[[noreturn]]` when:
1. It only exits by throwing an exception; or
2. It loops endlessly; or
3. It causes program termination.

## Example
```cpp
[[noreturn]] void kill_the_process() // Compliant
{
 std::abort(); // Note - std::abort is also [[noreturn]]
}

[[noreturn]] void throw_some() // Compliant - only exits with an exception
{
 throw 42;
}

[[noreturn]] void g( bool b ) // Non-compliant - returns if 'b' is false
{
 if ( b )
 {
 throw std::exception{};
 }
}
```

## See also
Rule 6.2.2

---

Copyright The MISRA Consortium Limited © [Date - October 2023].
