
Only use a `break` in a non-empty switch case statement if you need to break
before the end of the case body.  Dart does not support fallthrough execution
for non-empty cases, so `break`s at the end of non-empty switch case statements
are unnecessary.

**BAD:**
```dart
switch (1) {
  case 1:
    print("one");
    break;
  case 2:
    print("two");
    break;
}
```

**GOOD:**
```dart
switch (1) {
  case 1:
    print("one");
  case 2:
    print("two");
}
```

```dart
switch (1) {
  case 1:
  case 2:
    print("one or two");
}
```

```dart
switch (1) {
  case 1:
    break;
  case 2:
    print("just two");
}
```

NOTE: This lint only reports unnecessary breaks in libraries with a
[language version](https://dart.dev/guides/language/evolution#language-versioning)
of 3.0 or greater. Explicit breaks are still required in Dart 2.19 and below.