This warning occurs in conjunction with issue F403, `'from module import *' used`. It means that the variable `name` *could* be undefined, but flake8 cannot be sure because it also *could* also be imported in the star imports.

Confirm that the variable is defined in the star imports. If it is, explicitly import it instead of importing `*`. If not, then define the variable.

### Anti-pattern

```python
from mymodule import *

def print_name():
    print(name)  # name could be defined in mymodule
```

### Best practice

Either explicitly import `name`...

```python
from mymodule import name

def print_name():
    print(name)
```

...or define `name`.

```python
from mymodule import *

def print_name(name):
    print(name)
```
