Makes sure that the pullPolicy is set to Always. This makes sure that imagePullSecrets are always validated.

# Details
The default image pull policy would store the pulled image in the node’s cache which can be accessed by all pods on that node.
This configuration has the following known security issue.
Pod A has the necessary credentials for image S, pulls it and consumes the secret.
The image is stored in the node’s cache.
Pod B located on the same node does not have the necessary credentials but uses the cached image without the need to pull the image again.
It circumvents the container registry security.
Setting the value `always` for the image pull policy prevents the usage of a cached image because every pod needs to pull the image whenever it wants to use it and this requires to pass the registry credentials check.

# Further Reading:
- Liz Rice and Michael Hausenblas. Kubernetes Security. First Edition. Sebastopol: O’Reilly Media, Inc., 2018. isbn: 9781492039068.
- Thomas Stringer. Kubernetes’ AlwaysPullImages Admission Control - the Impor- tance, Implementation, and Security Vulnerability in its Absence. 2018. url: https://trstringer.com/kubernetes-alwayspullimages/