<h2>Why is this an issue?</h2>
<p><code>switch</code> statements and expressions are useful when there are many different cases depending on the value of the same expression.</p>
<p>When a <code>switch</code> statement or expression is simple enough, the code will be more readable with a single <code>if</code>,
<code>if-else</code> or ternary conditional operator.</p>
<h3>Noncompliant code example</h3>
<pre>
switch (variable)
{
  case 0:
    doSomething();
    break;
  default:
    doSomethingElse();
    break;
}

var foo = variable switch
{
  0 =&gt; doSomething(),
  _ =&gt; doSomethingElse(),
}
</pre>
<h3>Compliant solution</h3>
<pre>
if (variable == 0)
{
  doSomething();
}
else
{
  doSomethingElse();
}

var foo = variable == 0
  ? doSomething()
  : doSomethingElse();
</pre>

