<h2>Why is this an issue?</h2>
<p><a href="https://en.wikipedia.org/wiki/Short-circuit_evaluation">Short-circuit evaluation</a> is an evaluation strategy for <a
href="https://en.wikipedia.org/wiki/Logical_connective">Boolean operators</a>, that doesn’t evaluates the second argument of the operator if it is not
needed to determine the result of the operation.</p>
<p>C# provides logical operators that implement short-circuit evaluation: <code>&amp;&amp;</code> and <code>||</code>, as well as non-short-circuit
versions: <code>&amp;</code> and <code>|</code>. Unlike short-circuit operators, non-short-circuit ones evaluate both operands and afterwards perform
the logical operation.</p>
<p>For example <code>false &amp;&amp; FunctionCall()</code> always results in <code>false</code>, even when <code>FunctionCall</code> invocation would
raise an exception. Instead, <code>false &amp; FunctionCall()</code> also evaluates <code>FunctionCall()</code>, and results in an exception if
<code>FunctionCall()</code> invocation raises an exception.</p>
<p>Similarly, <code>true || FunctionCall()</code> always results in <code>true</code>, no matter what the return value of <code>FunctionCall()</code>
would be.</p>
<p>The use of non-short-circuit logic in a boolean context is likely a mistake - one that could cause serious program errors as conditions are
evaluated under the wrong circumstances.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre data-diff-id="1" data-diff-type="noncompliant">
if (GetTrue() | GetFalse()) // Noncompliant: both sides evaluated
{
}
</pre>
<h4>Compliant solution</h4>
<pre data-diff-id="1" data-diff-type="compliant">
if (GetTrue() || GetFalse()) // Compliant: short-circuit logic used
{
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/operators/boolean-logical-operators">Boolean logical operators -
  AND, OR, NOT, XOR</a> </li>
  <li> <a href="https://en.wikipedia.org/wiki/Short-circuit_evaluation">Short-circuit evaluation</a> </li>
  <li> <a href="https://en.wikipedia.org/wiki/Logical_connective">Boolean operators</a> </li>
</ul>
<h3>Articles &amp; blog posts</h3>
<ul>
  <li> <a href="https://ericlippert.com/2015/11/02/when-would-you-use-on-a-bool/">Eric Lippert’s blog - When would you use &amp; on a bool?</a> </li>
</ul>

