<h2>Why is this an issue?</h2>
<p>Static field initializers are executed in the order in which they appear in the class from top to bottom. Thus, placing a static field in a class
above the field or fields required for its initialization will yield unexpected results.</p>
<h3>Noncompliant code example</h3>
<pre>
class MyClass
{
  public static int X = Y; // Noncompliant; Y at this time is still assigned default(int), i.e. 0
  public static int Y = 42;
}
</pre>
<h3>Compliant solution</h3>
<pre>
class MyClass
{
  public static int Y = 42;
  public static int X = Y;
}
</pre>
<p>or</p>
<pre>
class MyClass
{
  public static int X;
  public static int Y = 42;

  static MyClass()
  {
    X = Y;
  }
}
</pre>

