<h2>Why is this an issue?</h2>
<p>Numbers are infinite, but the types that hold them are not. Each numeric type has hard upper and lower bounds. Try to calculate or assign numbers
beyond those bounds, and the result will be a value that has silently wrapped around from the expected positive value to a negative one, or vice
versa.</p>
<h2>Noncompliant code example</h2>
<pre>
public int Transform(int value)
{
    if (value &lt;= 0)
    {
        return value;
    }
    int number = int.MaxValue;
    return number + value;  // Noncompliant
}
</pre>
<h2>Compliant solution</h2>
<pre>
public long Transform(int value)
{
    if (value &lt;= 0)
    {
        return value;
    }
    long number = int.MaxValue;
    return number + value;
}
</pre>
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> STIG Viewer - <a href="https://stigviewer.com/stig/application_security_and_development/2023-06-08/finding/V-222612">Application Security and
  Development: V-222612</a> - The application must not be vulnerable to overflow attacks. </li>
</ul>

