<h2>Why is this an issue?</h2>
<p>Type inference enables the call of a generic method without explicitly specifying its type arguments. This is not possible when a parameter type is
missing from the argument list.</p>
<h3>Noncompliant code example</h3>
<pre>
using System;

namespace MyLibrary
{
  public class Foo
  {
    public void MyMethod&lt;T&gt;()  // Noncompliant
    {
        // this method can only be invoked by providing the type argument e.g. 'MyMethod&lt;int&gt;()'
    }
  }
}
</pre>
<h3>Compliant solution</h3>
<pre>
using System;

namespace MyLibrary
{
  public class Foo
  {
    public void MyMethod&lt;T&gt;(T param)
    {
        // type inference allows this to be invoked 'MyMethod(arg)'
    }
  }
}
</pre>

