<h2>Why is this an issue?</h2>
<p>Private fields which are written but never read are a case of "dead store". Changing the value of such a field is useless and most probably
indicates an error in the code.</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
public class Rectangle
{
  private readonly int length;
  private readonly int width;  // Noncompliant: width is written but never read

  public Rectangle(int length, int width)
  {
    this.length = length;
    this.width = width;
  }

  public int Surface
  {
    get
    {
      return length * width;
    }
  }
}
</pre>
<p>Remove this field if it doesn’t need to be read, or fix the code to read it.</p>
<pre data-diff-id="1" data-diff-type="compliant">
public class Rectangle
{
  private readonly int length;
  private readonly int width;

  public Rectangle(int length, int width)
  {
    this.length = length;
    this.width = width;
  }

  public int Surface
  {
    get
    {
      return length * width;
    }
  }
}
</pre>
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/563">CWE-563 - Assignment to Variable without Use ('Unused Variable')</a> </li>
</ul>

