﻿## SA1004

<table>
<tr>
  <td>TypeName</td>
  <td>SA1004DocumentationLinesMustBeginWithSingleSpace</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1004</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

A line within a documentation header above a C# element does not begin with a single space.

## Rule description

A violation of this rule occurs when a line within a documentation header does not begin with a single space. For example:

```csharp
///<summary>
///The summary text.
///</summary>
///   <param name="x">The document root.</param>
///    <param name="y">The Xml header token.</param>
private void Method1(int x, int y)
{
}
```

The header lines should begin with a single space after the three leading forward slashes:

```csharp
/// <summary>
/// The summary text.
/// </summary>
/// <param name="x">The document root.</param>
/// <param name="y">The Xml header token.</param>
private void Method1(int x, int y)
{
}
```

## How to fix violations

To fix a violation of this rule, ensure that the header line begins with a single space.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1004:DocumentationLinesMustBeginWithSingleSpace", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1004 // DocumentationLinesMustBeginWithSingleSpace
#pragma warning restore SA1004 // DocumentationLinesMustBeginWithSingleSpace
```
