﻿## SA1016

<table>
<tr>
  <td>TypeName</td>
  <td>SA1016OpeningAttributeBracketsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1016</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

An opening attribute bracket within a C# element is not spaced correctly.

## Rule description

A violation of this rule occurs when the spacing around an opening attribute bracket is not correct.

An opening attribute bracket should never be followed by whitespace, unless the bracket is the last character on the line.

## How to fix violations

To fix a violation of this rule, ensure that there is no whitespace after the opening attribute bracket.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1016:OpeningAttributeBracketsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1016 // OpeningAttributeBracketsMustBeSpacedCorrectly
#pragma warning restore SA1016 // OpeningAttributeBracketsMustBeSpacedCorrectly
```
