﻿## SA1411

<table>
<tr>
  <td>TypeName</td>
  <td>SA1411AttributeConstructorMustNotUseUnnecessaryParenthesis</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1411</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

## Cause

An attribute declaration does not contain any parameters, yet it still includes parenthesis.

## Rule description

When an attribute declaration does not contain any parameters, the parenthesis around the parameters are optional.

A violation of this rule occurs when unnecessary parenthesis have been used in an attribute constructor. For example:

```csharp
[Serializable()]
```

The parenthesis are unnecessary and should be removed:

```csharp
[Serializable]
```

## How to fix violations

Remove the unnecessary parenthesis.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainabilityRules", "SA1411:AttributeConstructorMustNotUseUnnecessaryParenthesis", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1411 // AttributeConstructorMustNotUseUnnecessaryParenthesis
#pragma warning restore SA1411 // AttributeConstructorMustNotUseUnnecessaryParenthesis
```
