## SA1414

<table>
<tr>
  <td>TypeName</td>
  <td>SA1414TupleTypesInSignaturesShouldHaveElementNames</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1414</td>
</tr>
<tr>
  <td>Category</td>
  <td>Maintainability Rules</td>
</tr>
</table>

:memo: This rule is new for StyleCop Analyzers, and was not present in StyleCop Classic.
:memo: This rule is only active for C# 7.0 and higher

## Cause

A tuple type without element names is present in a member declaration.

## Rule description

Tuple types appearing in member declarations should have explicitly named elements.  See the documentation on [tuple types](https://docs.microsoft.com/en-us/dotnet/csharp/tuples) for information on how to work with tuples in C# 7.

For example, the following code would produce a violation of this rule:

```csharp
public class ExampleClass
{
  public (int, int) ExampleMethod() // SA1414
  {
  }
}
```

The following code would not produce any violations:

```csharp
public class ExampleClass
{
  public (int valueA, int valueB) ExampleMethod()
  {
  }
}
```

## How to fix violations

To fix a violation of this rule, provide an element name for each tuple element.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.MaintainAbilityRules", "SA1414:TupleTypesInSignaturesShouldHaveElementNames", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1414 // Tuple types appearing in member declarations should have explicitly named tuple elements
#pragma warning restore SA1414 // Tuple types appearing in member declarations should have explicitly named tuple elements
```
