﻿## SA1511

<table>
<tr>
  <td>TypeName</td>
  <td>SA1511WhileDoFooterMustNotBePrecededByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1511</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

The while footer at the bottom of a do-while statement is separated from the statement by a blank line.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

A violation of this rule occurs when the while keyword at the bottom of a do-while statement is separated from the main part of the statement by one or more blank lines. For example:

```csharp
do
{
    Console.WriteLine("Loop forever");
}

while (true);
```

## How to fix violations

To fix a violation of this rule, remove any blank lines before the while keyword.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1511:WhileDoFooterMustNotBePrecededByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1511 // WhileDoFooterMustNotBePrecededByBlankLine
#pragma warning restore SA1511 // WhileDoFooterMustNotBePrecededByBlankLine
```
