<h2>Why is this an issue?</h2>
<p>The counter of a <code>for</code> loop should be updated in the loop’s increment clause. The purpose of a <code>for</code> loop is to iterate over
a range using a counter variable. It should not be used for other purposes, and alternative loops should be used in those cases.</p>
<p>If the counter is not updated, the loop will be infinite with a constant counter variable. If this is intentional, use a <code>while</code> or
<code>do</code> <code>while</code> loop instead of a <code>for</code> loop.</p>
<p>If the counter variable is updated within the loop’s body, try to move it to the increment clause. If this is impossible due to certain conditions,
replace the <code>for</code> loop with a <code>while</code> or <code>do</code> <code>while</code> loop.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<p>Move the counter variable update to the loop’s increment clause.</p>

```java
for (int i = 0; i < 10; ) { // Noncompliant, i not updated in increment clause
  // ...
  i++;
}
```

```java
int sum = 0
for (int i = 0; i < 10; sum++) { // Noncompliant, i not updated in increment clause
  // ...
  i++;
}
```
<h4>Compliant solution</h4>

```java
for (i = 0; i < 10; i++) { // Compliant
  // ...
}
```

```java
int sum = 0
for (int i = 0; i < 10; i++) { // Compliant
  // ...
  sum++;
}
```
<h4>Noncompliant code example</h4>
<p>If this is impossible and the counter variable must be updated in the loop’s body, use a <code>while</code> or <code>do</code> <code>while</code>
loop instead.</p>

```java
for (int sum = 0; sum < 10) { // Noncompliant, sum not updated in increment clause
  // ...
  if (condition) sum++;
  // ...
}
```
<h4>Compliant solution</h4>

```java
int sum = 0;
while (sum < 10) { // Compliant
  // ...
  if (condition) sum++;
  // ...
}
```