<h2>Why is this an issue?</h2>
<p>In regular expressions, anchors (<code>^</code>, <code>$</code>, <code>\A</code>, <code>\Z</code> and <code>\z</code>) have higher precedence than
the <code>|</code> operator. So in a regular expression like <code>^alt1|alt2|alt3$</code>, <code>alt1</code> would be anchored to the beginning,
<code>alt3</code> to the end and <code>alt2</code> wouldn’t be anchored at all. Usually the intended behavior is that all alternatives are anchored at
both ends. To achieve this, a non-capturing group should be used around the alternatives.</p>
<p>In cases where it is intended that the anchors only apply to one alternative each, adding (non-capturing) groups around the anchors and the parts
that they apply to will make it explicit which parts are anchored and avoid readers misunderstanding the precedence or changing it because they
mistakenly assume the precedence was not intended.</p>
<h3>Noncompliant code example</h3>

```java
^a|b|c$
```
<h3>Compliant solution</h3>

```java
^(?:a|b|c)$
```
<p>or</p>

```java
^a$|^b$|^c$
```
<p>or, if you do want the anchors to only apply to <code>a</code> and <code>c</code> respectively:</p>

```java
(?:^a)|b|(?:c$)
```