<h2>Why is this an issue?</h2>
<p>Regular expressions have their own syntax that is understood by regular expression engines. Those engines will throw an exception at runtime if
they are given a regular expression that does not conform to that syntax.</p>
<p>To avoid syntax errors, special characters should be escaped with backslashes when they are intended to be matched literally and references to
capturing groups should use the correctly spelled name or number of the group.</p>
<p>To match a literal string instead of a regular expression, either all special characters should be escaped, the <code>Pattern.LITERAL</code> flag
or methods that don’t use regular expressions should be used.</p>
<h3>Noncompliant code example</h3>

```java
Pattern.compile("([");
str.matches("([");
str.replaceAll("([", "{");
str.matches("(\\w+-(\\d+)");
```
<h3>Compliant solution</h3>

```java
Pattern.compile("\\(\\[");
Pattern.compile("([", Pattern.LITERAL);
str.equals("([");
str.replace("([", "{");
str.matches("(\\w+)-(\\d+)");
```