<h2>Why is this an issue?</h2>
<p>When the execution is not explicitly terminated at the end of a switch case, it continues to execute the statements of the following case. While
this is sometimes intentional, it often is a mistake which leads to unexpected behavior.</p>
<h3>Noncompliant code example</h3>

```js
switch (myVariable) {
  case 1:
    foo();
    break;
  case 2:  // Both 'doSomething()' and 'doSomethingElse()' will be executed. Is it on purpose ?
    doSomething();
  default:
    doSomethingElse();
    break;
}
```
<h3>Compliant solution</h3>

```js
switch (myVariable) {
  case 1:
    foo();
    break;
  case 2:
    doSomething();
    break;
  default:
    doSomethingElse();
    break;
}
```
<h3>Exceptions</h3>
<p>This rule is relaxed in the following cases:</p>

```js
switch (myVariable) {
  case 0:                                // Empty case used to specify the same behavior for a group of cases.
  case 1:
    doSomething();
    break;
  case 2:                                // Use of return statement
    return;
  case 3:                               // Ends with comment when fall-through is intentional
    console.log("this case falls through")
    // fall through
  case 4:                                // Use of throw statement
    throw new IllegalStateException();
  case 5:                                // Use of continue statement
    continue;
  default:                               // For the last case, use of break statement is optional
    doSomethingElse();
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/484">CWE-484 - Omitted Break Statement in Switch</a> </li>
</ul>