<h2>Why is this an issue?</h2>
<p>When a function is called, it executes its block of code and uses a <code>return</code> statement within the function to specify the value that the
function will produce as its result. This returned value can then be used or assigned to a variable in the calling code.</p>
<p>If a function returns a value that is not used or assigned to a variable, it may indicate that the function is not being used correctly or that
there is a mistake in the code. This can make the code harder to understand and maintain, and can also lead to errors if the return value is needed
later in the code.</p>
<p>Ignoring the return value of a function can be a sign of poor coding practices. It can indicate that the developer did not fully understand the
purpose of the function or did not take the time to properly integrate it into the code.</p>
<p>This rule triggers an issue only on a predefined list of methods from built-in objects (<code>String</code>, <code>Number</code>,
<code>Date</code>, <code>Array</code>, <code>Math</code>, and <code>RegExp</code>) to prevent generating any false-positives.</p>

```js
'hello'.lastIndexOf('e'); // Noncompliant: The return value is lost
```
<p>Ensure that the return value of the function is used by assigning the return value to a variable.</p>

```js
let lastIndex = 'hello'.lastIndexOf('e');
```
<p>Or use the value directly as part of an expression.</p>

```js
console.log('hello'.lastIndexOf('e'));
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/String"><code>String</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Number"><code>Number</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date"><code>Date</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array"><code>Array</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math"><code>Math</code></a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/RegExp"><code>RegExp</code></a> </li>
</ul>