<h2>Why is this an issue?</h2>
<p>The <code>in</code> operator is used to check if a property is in an object or its <a
href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Inheritance_and_the_prototype_chain">prototype chain</a>.</p>
<p>When used on an array, it will compare against the indexes of the array, not the values. This is likely not to be the expected behavior.</p>

```js
function func() {
    const arr = ["a", "b", "c"];

    const expectedValue = "b";
    if (expectedValue in arr) { // Noncompliant: will be always false
        return expectedValue + " found in the array";
    } else {
        return expectedValue + " not found";
    }
}
```
<p>Use the method <code>Array.prototype.includes()</code> to determine whether an array contains a certain value. If the actual intention is to check
for an array slot, use <code>Object.prototype.hasOwnProperty()</code>.</p>

```js
function func() {
    const arr = ["a", "b", "c"];

    const expectedValue = "b";
    if (arr.includes(expectedValue)) {
        return expectedValue + " found in the array";
    } else {
        return expectedValue + " not found";
    }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/in"><code>in</code> operator</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/for...in"><code>for...in</code></a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Array/includes"><code>Array.prototype.includes()</code></a>
  </li>
</ul>