<p>Constructors should not return values.</p>
<h2>Why is this an issue?</h2>
<p>JavaScript allows returning a value from a class constructor. This obscure feature is rarely used and is more likely a bug than the developer’s
intention.</p>
<h2>How to fix it</h2>
<p>Do not return anything from the constructor.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
class TextMessage {
    constructor(msg) {
        this.text = msg;
        return msg; // Noncompliant
    }
}
```
<h4>Compliant solution</h4>

```js
class TextMsg1 {
    constructor(msg) {
        this.text = msg;
    }
}


class TextMsg2 {
    constructor(msg) {
        if (!msg) {
            return; // ok to return nothing for flow control
        }
        this.text = msg;
    }
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Classes/constructor">constructor</a> </li>
</ul>