<h2>Why is this an issue?</h2>
<p>React Legacy APIs provide a way to define the default values for props and check the prop types at runtime. This rule verifies if a
<code>defaultProps</code> definition does have a corresponding <code>propTypes</code> definition. If it is missing, this could be the result of errors
in refactoring or a spelling mistake.</p>
<p>It is also an error if a <code>defaultProp</code> has <code>propType</code> that is marked as <code>isRequired</code>.</p>
<h2>How to fix it in PropTypes</h2>

```js
function MyComponent({foo, bar}) {
  return <div>{foo}{bar}</div>;
}

MyComponent.propTypes = {
  foo: React.PropTypes.string.isRequired,
};

MyComponent.defaultProps = {
  foo: "foo", // Noncompliant: foo is a required prop
  bar: "bar", // Noncompliant: bar propType is missing
};
```
<p>To fix the issue, verify that each <code>defaultProp</code> has a corresponding <code>propType</code> definition and is not marked as
<code>isRequired</code>.</p>

```js
function MyComponent({foo, bar}) {
  return <div>{foo}{bar}</div>;
}

MyComponent.propTypes = {
  foo: React.PropTypes.string,
  bar: React.PropTypes.string,
};

MyComponent.defaultProps = {
  foo: "foo",
  bar: "bar",
};
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> React Documentation - <a href="https://react.dev/learn/typescript#typescript-with-react-components">TypeScript with React Components</a> </li>
  <li> React Documentation - <a href="https://react.dev/learn/passing-props-to-a-component#specifying-a-default-value-for-a-prop">Specifying a default
  value for a prop</a> </li>
  <li> React Documentation - <a href="https://legacy.reactjs.org/docs/typechecking-with-proptypes.html">Typechecking With PropTypes</a> </li>
</ul>