<h2>Why is this an issue?</h2>
<p>Passing a collection as an argument to the collection’s own method is either an error - some other argument was intended - or simply nonsensical
code.</p>
<p>Further, because some methods require that the argument remain unmodified during the execution, passing a collection to itself can result in
undefined behavior.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```kotlin
val objs = mutableListOf<Any>()
objs.add("Hello")

objs.add(objs) // Noncompliant; StackOverflowException if objs.hashCode() called
objs.addAll(objs) // Noncompliant; behavior undefined
objs.containsAll(objs) // Noncompliant; always true
objs.removeAll(objs) // Noncompliant; confusing. Use clear() instead
objs.retainAll(objs) // Noncompliant; NOOP
```
<h4>Compliant solution</h4>

```kotlin
val newList = mutableListOf<Any>()
val objs = mutableListOf<Any>()
objs.add("Hello")

objs.containsAll(newList) // Compliant
objs.addAll(newList) // Compliant
objs.removeAll(newList) // Compliant
objs.retainAll(newList) // Compliant
```