<h2>Why is this an issue?</h2>
<p>While it is not inherently wrong to use the closing PHP tag, developers often choose to omit it to minimize the chances of encountering issues and
to follow established best practices and coding standards.</p>
<h3>What is the potential impact?</h3>
<p>There are a few reasons developers should avoid using the closing PHP tag <code>?&gt;</code> at the end of a file:</p>
<p>If a developer accidentally adds whitespace or any other characters after the closing PHP tag, it can cause PHP to automatically start output
buffering. This can lead to unexpected behavior when trying to modify headers or perform redirects because headers need to be sent before any
content.</p>
<p>Some frameworks and coding standards explicitly discourage the use of the closing PHP tag to ensure compatibility and portability across different
PHP environments and versions.</p>
<p>Following a consistent coding style and adhering to best practices are important for code readability and maintainability. Many coding standards,
such as the PER (PHP Evolving Recommendation), recommend omitting the closing PHP tag for the reasons mentioned above.</p>
<h2>How to fix it</h2>
<p>Omitting the closing PHP tag can help prevent the injection of unintended output. It also eliminates the need to worry about removing or handling
the closing tag when modifying or concatenating multiple PHP files, making code maintenance easier.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/language.basic-syntax.phptags.php">PHP Manual - PHP tags</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> <a href="https://www.php-fig.org/per/coding-style/#22-files">PER Coding Style 2.0 - Files</a> </li>
</ul>