<h2>Why is this an issue?</h2>
<p>Boolean operators are used to combine conditional statements based on their value. In PHP, there are two different sets of operators to use for AND
and OR:</p>
<ul>
  <li> <code>&amp;&amp;</code> / <code>||</code> </li>
  <li> <code>and</code> / <code>or</code> </li>
</ul>
<p>The difference between these sets is the precedence, which specifies how "tightly" two expressions are bound together. Because <code>and</code> /
<code>or</code> have a lower precedence than almost any other operator, using them instead of <code>&amp;&amp;</code> / <code>||</code> may not have
the result you expect.</p>
<h3>Noncompliant code example</h3>
<p>In both cases, the assignment has a higher precedence over the boolean operation.</p>

```php
$resultAnd = true and false; // Noncompliant: $resultAnd == true

$resultOr = false or true; // Noncompliant: $resultOr == false
```
<h3>Compliant solution</h3>

```php
$resultAnd = true && false; // $resultAnd == false

$resultOr = false || true; // $resultOr == true
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> <a href="https://www.php.net/manual/en/language.operators.logical.php">PHP Manual - Logical Operators</a> </li>
  <li> <a href="https://www.php.net/manual/en/language.operators.precedence.php">PHP Manual - Operator Precedence</a> </li>
</ul>