<p>The <code>cgi.force_redirect</code> <em>php.ini</em> configuration controls the behavior of the PHP engine when used in CGI mode. In particular, it
prevents CGI scripts from being directly requested without prior web server or application processing.</p>
<p>When disabled, CGI scripts can be requested directly.</p>
<h2>Why is this an issue?</h2>
<p>Pre-processing on the server side is often required to check users authentication when working in CGI mode. Those preliminary actions can also
position diverse configuration parameters necessary for the CGI script to work correctly.</p>
<h3>What is the potential impact?</h3>
<p>CGI scripts might behave unexpectedly if the proper configuration is not set up before they are accessed.</p>
<p>Most serious security-related consequences will affect the authorization and authentication mechanisms of the application. When the web server is
responsible for authenticating clients and forwarding the proper identity to the script, direct access will bypass this authentication step.</p>
<p>Attackers could also provide arbitrary identities to the CGI script by forging specific HTTP headers or parameters. They could then impersonate any
legitimate user of the application.</p>
<h2>How to fix it</h2>
<p><code>cgi.force_redirect</code> should be enforced in the main PHP configuration file.</p>
<p>Note that this parameter is enabled by default.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
; php.ini
cgi.force_redirect=0  ; Noncompliant
```
<h4>Compliant solution</h4>

```php
; php.ini
cgi.force_redirect=1  ; Noncompliant
```
<h3>Pitfalls</h3>
<p>The <code>cgi.force_redirect</code> is not supported by all web servers. For example, Microsoft IIS web server is unable to differentiate an
internally redirected request from a normal one.</p>
<p>While using such a server, the <code>cgi.force_redirect</code> parameter will have to be disabled for the CGI scripts to work properly. In that
case, it is important to ensure the CGI behavior is aware of the security threat.</p>
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 Category A5 - Security Misconfiguration</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration">Top 10 2017 Category A6 - Security
  Misconfiguration</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/305">CWE-305 - Authentication Bypass by Primary Weakness</a> </li>
</ul>