<h2>Why is this an issue?</h2>
<p>For clarity, all overloads of the same method should be grouped together. That lets both users and maintainers quickly understand all the current
available options.</p>
<h3>Noncompliant code example</h3>

```ts
interface MyInterface {
  doTheThing(): number;
  doTheOtherThing(): string;
  doTheThing(str: string): string;  // Noncompliant
}
```
<h3>Compliant solution</h3>

```ts
interface MyInterface {
  doTheThing(): number;
  doTheThing(str: string): string;
  doTheOtherThing(): string;
}
```