<h2>Why is this an issue?</h2>
<p>The public API of a framework, plugin, or library is the way its provider intended it to be used. API stability and compatibility (within the same
major version number) of a library are guaranteed only for its public API.</p>
<p>Internal APIs are mere implementation details and are prone to breaking changes as the implementation of the library changes. No guarantees are
being made about them. Therefore, users should not use internal APIs, even when visible.</p>
<h3>What is the potential impact?</h3>
<h4>Code Stability</h4>
<p>If not fixed, your code might break when the library is upgraded to a new version, even if only the minor version number or the patch number
changes.</p>
<h2>How to fix it</h2>
<p>Replace internal API usage with the public API designed for your use case. This may imply a refactoring of the affected code if no one-to-one
replacement is available in the public API. If a specific functionality is required, copying the required parts of the implementation into your code
may even be better than using the internal API.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
import { _parseWith } from './node_modules/foo/helpers'
```
<h4>Compliant solution</h4>

```ts
import { parse } from 'foo'
```