<h2>Why is this an issue?</h2>
<p>ARIA (Accessible Rich Internet Applications) attributes are used to enhance the accessibility of web content and web applications. These attributes
provide additional information about an element’s role, state, properties, and values to assistive technologies like screen readers.</p>
<p>The <code>aria-activedescendant</code> attribute is used to enhance the accessibility of composite widgets by managing focus within them. It allows
a parent element to retain active document focus while indicating which of its child elements has secondary focus. This attribute is particularly
useful in interactive components like search typeahead select lists, where the user can navigate through a list of options while continuing to type in
the input field.</p>
<p>This rule checks that DOM elements with the <code>aria-activedescendant</code> property either have an inherent tabIndex or declare one.</p>
<h2>How to fix it in JSX</h2>
<p>Make sure that DOM elements with the <code>aria-activedescendant</code> property have a <code>tabIndex</code> property, or use an element with an
inherent one.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```ts
<div aria-activedescendant={descendantId}>
  {content}
</div>
```
<h4>Compliant solution</h4>

```ts
<div aria-activedescendant={descendantId} tabIndex={0}>
  {content}
</div>
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/ARIA_Techniques">Using ARIA: Roles, states, and
  properties</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Roles">ARIA roles (Reference)</a> </li>
  <li> MDN web docs - <a
  href="https://developer.mozilla.org/en-US/docs/Web/Accessibility/ARIA/Attributes/aria-activedescendant"><code>aria-activedescendant</code>
  attribute</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/tabindex"><code>tabIndex</code> attribute</a> </li>
</ul>
<h3>Standards</h3>
<ul>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria-1.2/">Accessible Rich Internet Applications (WAI-ARIA) 1.2</a> </li>
  <li> W3C - <a href="https://www.w3.org/TR/wai-aria/#composite">Composite role</a> </li>
</ul>