# Static Over Final Class

Prefer `static` over `final class`

* **Identifier:** static_over_final_class
* **Enabled by default:** Yes
* **Supports autocorrection:** No
* **Kind:** idiomatic
* **Analyzer rule:** No
* **Minimum Swift compiler version:** 5.0.0
* **Default configuration:** warning

## Non Triggering Examples

```swift
class C {
    static func f() {}
}
```

```swift
class C {
    static var i: Int { 0 }
}
```

```swift
class C {
    static subscript(_: Int) -> Int { 0 }
}
```

```swift
class C {
    class func f() {}
}
```

```swift
final class C {}
```

```swift
final class C {
    class D {
      class func f() {}
    }
}
```

## Triggering Examples

```swift
class C {
    ↓final class func f() {}
}
```

```swift
class C {
    ↓final class var i: Int { 0 }
}
```

```swift
class C {
    ↓final class subscript(_: Int) -> Int { 0 }
}
```

```swift
final class C {
    ↓class func f() {}
}
```

```swift
class C {
    final class D {
        ↓class func f() {}
    }
}
```