import{_ as o,c as i,ak as t,o as a}from"./chunks/framework.AfHpRKMk.js";const d=JSON.parse('{"title":"Monitoring a Teamscale Instance","description":"","frontmatter":{"title":"Monitoring a Teamscale Instance"},"headers":[],"relativePath":"howto/monitoring-teamscale/index.md","filePath":"howto/monitoring-teamscale/index.md"}'),r={name:"howto/monitoring-teamscale/index.md"};function l(s,e,n,c,m,u){return a(),i("div",null,[...e[0]||(e[0]=[t('<h1 id="how-to-monitor-a-teamscale-instance" tabindex="-1">How to Monitor a Teamscale Instance <a class="header-anchor" href="#how-to-monitor-a-teamscale-instance" aria-label="Permalink to &quot;How to Monitor a Teamscale Instance&quot;">​</a></h1><p>To check and monitor the state of a Teamscale instance, the following options are available:</p><h2 id="monitoring-via-web-ui" tabindex="-1">Monitoring via Web UI <a class="header-anchor" href="#monitoring-via-web-ui" aria-label="Permalink to &quot;Monitoring via Web UI&quot;">​</a></h2><p>Teamscale provides many helpful metrics via the <strong>System Information</strong> view in the <strong>System</strong> perspective. In addition, the logs (e.g., <strong>Worker Log</strong>) can be helpful for diagnosis.</p><h2 id="api-endpoint-for-nagios" tabindex="-1">API Endpoint for Nagios <a class="header-anchor" href="#api-endpoint-for-nagios" aria-label="Permalink to &quot;API Endpoint for Nagios&quot;">​</a></h2><p>The URLs <code>api/health-check</code> and <code>api/health-metrics</code> provide check results and metrics in the <a href="https://assets.nagios.com/downloads/nagioscore/docs/nagioscore/3/en/pluginapi.html" target="_blank" rel="noreferrer">Nagios format</a>. This can be used with Nagios or compatible solutions, such as Sensu, to monitor the current health status of Teamscale. To integrate on the command-line, see the <code>monitoring</code> directory in your Teamscale distribution.</p><details class="details custom-block"><summary>Exposed Metrics</summary><p>General information about the instance</p><ul><li>State of the scheduler</li><li>If the instance has run out of memory</li><li>If the instance is running out of disk space</li><li>If the Java VM is running out of memory</li><li>If the license is valid or outdated</li><li>If the server certificate is valid</li><li>The version of Teamscale</li><li>Number of workers</li><li>The load of the worker</li><li>Number of licensed user</li><li>Number of users</li><li>Number of active users in specific time frames</li><li>Number of committers in specific time frames</li><li>Number of projects</li></ul></details><h2 id="api-endpoint-for-prometheus" tabindex="-1">API Endpoint for Prometheus <a class="header-anchor" href="#api-endpoint-for-prometheus" aria-label="Permalink to &quot;API Endpoint for Prometheus&quot;">​</a></h2><p>The URL <code>api/monitoring/prometheus</code> exposes various metrics of Teamscale in the <a href="https://prometheus.io/docs/instrumenting/exposition_formats/" target="_blank" rel="noreferrer">Prometheus format</a>. <a href="./../../reference/admin-settings/monitoring/#prometheus-service">Our reference documentation</a> contains more information on how to enable and configure Teamscale for use with Prometheus.</p><details class="details custom-block"><summary>Exposed Metrics</summary><p>General information about the instance</p><ul><li>Name of the instance</li><li>Name of the process</li><li>The version of Teamscale</li><li>If the instance is in shadow mode</li><li>State of the scheduler</li><li>Number of workers</li><li>The load of the workers</li><li>The current runtime of each worker</li><li>The size of the job queue</li><li>Days left until license expires</li><li>Number of licensed user</li><li>Number of users</li><li>Number of active users in specific time frames</li><li>Number of committers in specific time frames</li><li>Number of projects</li><li>CPU load</li><li>Number of logical CPU cores</li><li>Size of the RAM</li><li>Amount of used RAM</li><li>Detailed state of the Java VM <ul><li>Used RAM</li><li>Number of threads</li><li>Time spend in garbage collection</li><li>and more</li></ul></li><li>Statistics of the Internal String Abbreviator Cache</li><li>Statistics on service calls</li><li>Directory size of the working directory, storage directory, (git) repository directory and temp directory used by Teamscale</li><li>Amount of critical system events</li><li>Number of successful automatic backup runs</li></ul><p>Metrics for each project.</p><ul><li>Primary public ID of the project</li><li>Analysis state of the project</li><li>Number of connectors in specific states</li><li>Number of files</li><li>Number of lines of code</li><li>Number of commits in specific states</li><li>Number of the different log entries</li><li>Number of rolled back commits within the last 24 hours</li><li>Duration of rollback executions</li><li>Number of currently postponed rollbacks</li><li>Whether the project is paused</li><li>Statistics on pre-commit usage</li></ul><p>Storage performance metrics. These metrics are disabled by default because they are expensive to collect and are only useful for debugging. To enable these metrics set the flag <code>-Dcom.teamscale.storage-metrics.enabled=true</code>. More information how to set a flag can be seen <a href="./../../reference/administration-ts-installation/#jvm-arguments">here</a>.</p><ul><li>Number of opening operations for a store</li><li>Number of storage operations</li><li>Number of overall affected keys in storage operations</li><li>Number of overall bytes in keys</li><li>Number of overall bytes in values</li><li>Duration in milliseconds of storage operations</li></ul></details><h2 id="forwarding-teamscale-logs-to-splunk" tabindex="-1">Forwarding Teamscale Logs to Splunk <a class="header-anchor" href="#forwarding-teamscale-logs-to-splunk" aria-label="Permalink to &quot;Forwarding Teamscale Logs to Splunk&quot;">​</a></h2><p>Teamscale uses the Log4J logging framework and provides support for forwarding the generated logs to a Splunk server. Log forwarding can be configured using the <a href="https://dev.splunk.com/enterprise/docs/devtools/java/logging-java" target="_blank" rel="noreferrer">Splunk logging for Java</a> integration and Teamscale fully supports HTTP Event Collector (recommended) and TCP data inputs. See the default <code>log4j2.yaml</code> Log4J configuration file in the Teamscale distribution Zip for an example configuration. For further configuration options refer to the official <a href="https://dev.splunk.com/enterprise/docs/devtools/java/logging-java/howtouseloggingjava/enableloghttpjava/#2-Enable-HTTP-Event-Collector" target="_blank" rel="noreferrer">How to use Splunk logging for Java</a> page. To reduce load on the Splunk server, consider adjusting the <code>batch_interval</code>, <code>batch_size_bytes</code>, or <code>batch_size_count</code> of the Log4J appender for Splunk to reduce the frequency of log forwarding.</p>',12)])])}const h=o(r,[["render",l]]);export{d as __pageData,h as default};
