import{_ as a,c as t,ak as r,o as i}from"./chunks/framework.AfHpRKMk.js";const h=JSON.parse('{"title":"Security","description":"","frontmatter":{"title":"Security"},"headers":[],"relativePath":"reference/security-analyses/index.md","filePath":"reference/security-analyses/index.md"}'),s={name:"reference/security-analyses/index.md"};function o(n,e,l,c,d,p){return i(),t("div",null,[...e[0]||(e[0]=[r('<h1 id="security-analysis-capabilities" tabindex="-1">Security Analysis Capabilities <a class="header-anchor" href="#security-analysis-capabilities" aria-label="Permalink to &quot;Security Analysis Capabilities&quot;">​</a></h1><p>Teamscale provides comprehensive security analysis capabilities to help you identify and address vulnerabilities in your codebase, including support for static appplication security testing (SAST) methodology. Its security analysis capabilities include:</p><ul><li><strong>Static Code Analysis</strong>: Detects common security issues such as SQL injection, cross-site scripting (XSS), and insecure API usage. This detection mechanism is based on static analysis and it corresponds to static application security testing (SAST).</li><li><strong>Industry Standards</strong>: Integrates with industry-recognized security standards such as the OWASP Top 10 and CWE Top 25.</li><li><strong>Integration</strong>: Works seamlessly with CI/CD pipelines and other development tools to ensure security checks are part of your workflow.</li></ul><h2 id="which-programming-languages-are-supported" tabindex="-1">Which Programming Languages Are Supported <a class="header-anchor" href="#which-programming-languages-are-supported" aria-label="Permalink to &quot;Which Programming Languages Are Supported&quot;">​</a></h2><p>Teamscale provides almost 1000 security-related checks that can be enabled and configured as needed for your projects. In particular, Teamscale supports SAST for a wide range of programming languages by integrating with popular SAST tools. The following list shows the supported languages and the corresponding analyzers that can be used for SAST:</p><ul><li>ABAP: Abaplint, Code Inspector</li><li>C: Clang-Tidy, Cppcheck, Gitlab SAST/Semgrep</li><li>C#: Gitlab SAST/Semgrep, Security Code Scan, SonarLint</li><li>C++: Clang-Tidy, Cppcheck, Gitlab SAST/Semgrep</li><li>Dart: Dart Lint</li><li>Go: Gitlab SAST/Semgrep, Golanci-lint</li><li>Java: Gitlab SAST/Semgrep, SonarLint</li><li>JavaScript: ESLint, Gitlab SAST/Semgrep, SonarLint</li><li>Kotlin: Gitlab SAST/Semgrep, SonarLint</li><li>PHP: SonarLint</li><li>PowerShell: PowerShell Script Analyzer</li><li>Python: Bandit, Gitlab SAST/Semgrep</li><li>Objective-C: Gitlab SAST/Semgrep</li><li>Swift: Gitlab SAST/Semgrep</li><li>TypeScript: ESLint, Gitlab SAST/Semgrep, SonarLint</li></ul><p>This broad support allows Teamscale to help you identify security issues across diverse technology stacks and codebases. In addition, Teamscale has its own set of security checks, each analyzing one or even all programming languages that Teamscale supports.</p><p><em>The Cppcheck Premium integration (licensed separately) offers additional security checks for C and C++. For more detailed information about Cppcheck and its capabilities, you can reer to this resource available in the Teamscale documentation: <a href="https://docs.teamscale.com/changelog/v2025.1.x/#static-analysis-integrated-tools" target="_blank" rel="noreferrer">Static Analysis: Integrated Tools with v2025.1</a>.</em></p><h2 id="how-to-enable-sast" tabindex="-1">How To Enable SAST <a class="header-anchor" href="#how-to-enable-sast" aria-label="Permalink to &quot;How To Enable SAST&quot;">​</a></h2><p>When creating a project in Teamscale with a default analysis profile, the SAST checks are typically enabled automatically. This ensures that your code is analyzed for common security vulnerabilities right from the start, without requiring additional configuration.</p><p>Going further than the default analysis profiles, Teamscale provides customizable options that allow teams to tailor their security checks based on specific project needs and analysis performance requirements.</p><p>The following table shows the number of security-relevant checks enabled by default analysis profiles for three of the widespread programming languages:</p><table tabindex="0"><thead><tr><th>Language</th><th>Tools</th><th>Security Checks Enabled by Default</th></tr></thead><tbody><tr><td>ABAP</td><td>Code Inspector, Teamscale</td><td>96</td></tr><tr><td>C#</td><td>Security Code Scan, SonarLint, Teamscale</td><td>74</td></tr><tr><td>Java</td><td>SonarLint, Teamscale</td><td>17</td></tr><tr><td>JavaScript/TypeScript</td><td>SonarLint, Teamscale</td><td>29</td></tr><tr><td>Python</td><td>Bandit, Teamscale</td><td>32</td></tr></tbody></table><p><em>The numbers above are based on Teamscale version 2025.2. With new versions, more security checks are typically added and made available by default. Some tools are disabled by default, e.g., Cppcheck or Gitlab SAST/Semgrep, however they can easily be configured by using Teamscale&#39;s analysis profile editor starting with a default analysis profile.</em></p><h2 id="coverage-of-industry-recognized-security-standards" tabindex="-1">Coverage of Industry-recognized Security Standards <a class="header-anchor" href="#coverage-of-industry-recognized-security-standards" aria-label="Permalink to &quot;Coverage of Industry-recognized Security Standards&quot;">​</a></h2><p>Teamscale integrates with industry-recognized security standards to help you address the most critical security risks in your codebase. Teamscale provides strong coverage of the <a href="https://owasp.org/www-project-top-ten/" target="_blank" rel="noreferrer">OWASP Top 10:2021</a>, with checks for 10 out of the 10 categories for Java and JavaScript/Typescript, and 8 out of 10 categories for C#.</p><p>In addition, Teamscale includes checks for more than 10 of the weaknesses listed in the <a href="https://cwe.mitre.org/top25/" target="_blank" rel="noreferrer">CWE Top 25</a>, ensuring that your code is analyzed for many of the most dangerous and widespread software vulnerabilities.</p><p>Furthermore, Teamscale integrates with security standards specific to programming languages, such as <a href="https://www.autosar.org/" target="_blank" rel="noreferrer">AUTOSAR</a>, <a href="https://isocpp.github.io/CppCoreGuidelines/" target="_blank" rel="noreferrer">C++ Core Guidelines</a>, <a href="https://wiki.sei.cmu.edu/confluence/display/cplusplus" target="_blank" rel="noreferrer">CERT-C++</a>, and <a href="https://misra.org.uk/" target="_blank" rel="noreferrer">MISRA</a>, enhancing its ability to address language-specific security concerns.</p>',18)])])}const g=a(s,[["render",o]]);export{h as __pageData,g as default};
