/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.core.pattern;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.conqat.engine.commons.util.CommonUtils;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public class StringTransformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final PairList<Pattern, String> transformations;

    public StringTransformation() {
        this.transformations = new PairList();
    }

    public StringTransformation(PairList<Pattern, String> transformations) {
        this.transformations = transformations;
    }

    public void add(String searchPattern, String replacement) throws ConQATException {
        this.transformations.add((Object)CommonUtils.compilePattern((String)searchPattern), (Object)replacement);
    }

    public void add(Pattern searchPattern, String replacement) {
        this.transformations.add((Object)searchPattern, (Object)replacement);
    }

    public String apply(String string) {
        return StringUtils.replaceAll((String)string, this.transformations);
    }

    public boolean containsTransformations() {
        return !this.transformations.isEmpty();
    }

    public static StringTransformation fromStringPairs(PairList<String, String> input) throws ConQATException {
        return new StringTransformation((PairList<Pattern, String>)input.mapFirst(CommonUtils::compilePattern));
    }
}

