/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.admin;

import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.permissions.roles.EProjectPermission;
import com.teamscale.index.configuration.service.EProjectConfigurationVersion;
import com.teamscale.service.base.ApiBase;
import com.teamscale.service.framework.authorization.RequiresProjectPermission;
import com.teamscale.service.framework.util.ResponseUtils;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Response;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

@Path(value="api/projects/{project}/configuration/export")
public class ProjectConfigurationExportService
extends ApiBase {
    @GET
    @RequiresProjectPermission(value={EProjectPermission.VIEW})
    @Operation(summary="Export project configuration", description="Downloads the project configuration which is only the configuration and does not include the project data, analysis profiles or external accounts.", tags={"Project"})
    public Response exportProjectConfiguration() throws StorageException {
        ProjectConfiguration projectConfiguration = ProjectConfigurationUtils.getProjectConfigurationWithoutEmbeddedProfile((ProjectStorageSystem)this.getProjectStorageSystem());
        return ResponseUtils.toFileDownload((Object)projectConfiguration, (Enum)EProjectConfigurationVersion.CURRENT_VERSION, (String)(String.valueOf(this.serviceInfo.getPrimaryPublicId()) + ".tsproject"));
    }
}

